<?php
/**
 * Loads the WordPress environment and template.
 * @package WordPress
 */

/**
 * This file is not added by default to WordPress theme pages when outputting
 * feed links. 
 * @package WordPress
 */

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles', 1001 );
function theme_enqueue_styles() {
	etheme_child_styles();
}


function add_google_recaptcha_script() {
    $site_key = '6LedaJInAAAAABKuu9exz6B_ZA6BlhCyn22xyx2N'; // Replace with your actual Site Key
    wp_enqueue_script('google-recaptcha', "https://www.google.com/recaptcha/api.js?render=$site_key", array(), null, true);
}
add_action('wp_enqueue_scripts', 'add_google_recaptcha_script');


// Truncate product names in loops
function custom_truncate_product_title($title) {
    $max_words = 3; // Change this to the number of words you want to display
    $words = explode(' ', $title);

    if (count($words) > $max_words) {
        $title = implode(' ', array_slice($words, 0, $max_words)) . '...';
    }

    return $title;
}
add_filter('the_title', 'custom_truncate_product_title', 10, 2);

