<?php
/**
 * @var SLN_Plugin                        $plugin
 * @var string                            $formAction
 * @var string                            $submitName
 * @var SLN_Shortcode_Salon_ServicesStep $step
 */
if ($plugin->getSettings()->isDisabled()) {
	$message = $plugin->getSettings()->getDisabledMessage();
	?>
	<div class="sln-alert sln-alert--paddingleft sln-alert--problem">
		<?php echo empty($message) ? __('On-line booking is disabled', 'salon-booking-system') : $message ?>
	</div>
	<?php
} else {
	$style = $step->getShortcode()->getStyleShortcode();
	$size = SLN_Enum_ShortcodeStyle::getSize($style);
	$bb             = $plugin->getBookingBuilder();
	$currencySymbol = $plugin->getSettings()->getCurrencySymbol();
	$services = $step->getServices();
	?>
	<form id="salon-step-services" method="post" action="<?php echo $formAction ?>" role="form">
	<?php if ($size == '900') { ?>
		<div class="row sln-box--main">
			<div class="col-xs-12 col-md-8"><?php include "_services.php"; ?></div> <!-- The row closed inside _form_actions.php -->
	<?php } else {  // IF SIZE 900 // END ?>
		<div class="row sln-box--main">
			<div class="col-xs-12"><?php include "_services.php"; ?></div>
		</div>
	<?php } // IF SIZE 600 AND 400 // END ?>
	<?php include "_form_actions.php" ?>
        <input type="hidden" name="sln[customer_timezone]" value="<?php echo $bb->get('customer_timezone') ?>">
	</form>
	<?php
}