<?php
/**
 * @var SLN_Plugin $plugin
 * @var string $formAction
 * @var string $submitName
 */
if ($plugin->getSettings()->isDisabled()) {
    $message = $plugin->getSettings()->getDisabledMessage();
    ?>
    <div class="sln-alert sln-alert--paddingleft sln-alert--problem">
        <?php echo empty($message) ? __('On-line booking is disabled', 'salon-booking-system') : $message ?>
    </div>
    <?php
} else {
    $bb = $plugin->getBookingBuilder();
    $style = $step->getShortcode()->getStyleShortcode();
    $size = SLN_Enum_ShortcodeStyle::getSize($style);

    ?>

    <form method="post" action="<?php echo $formAction ?>" id="salon-step-date"
            data-intervals="<?php echo esc_attr(json_encode($intervalsArray)); ?>"
            <?php if((bool)SLN_Plugin::getInstance()->getSettings()->get('debug') && current_user_can( 'administrator' ) ): ?>
            data-debug="<?php echo esc_attr( json_encode( SLN_Helper_Availability_AdminRuleLog::getInstance()->getDateLog() ) ); ?>"
            <?php endif ?>>
        <?php if('900' == $size): ?>
            <div class="row sln-box--main"> <!-- The row closed inside _form_actions.php -->
                <?php include '_salon_date_pickers.php'; ?>
        <?php else: ?>
            <div class="row sln-box--main">
                <?php include '_salon_date_pickers.php'; ?>
            </div>
        <?php endif; ?>
        <?php include "_form_actions.php" ?>
    </form>
        
    <?php
}
