<?php

require_once __DIR__ . '/../../Third/mixpanel/vendor/autoload.php';

class SLN_Helper_Mixpanel_MixpanelServer
{
    protected $mp;

    public function __construct($token)
    {
        $this->mp = Mixpanel::getInstance($token, array(
            'debug'           => true,
            'use_ssl'         => true,
            'timeout'         => 3,
            'connect_timeout' => 3,
        ));
    }

    public function track($event, $data = array())
    {
        $data["distinct_id"] = $this->getDistinctID();
        // track an event
        $this->mp->track($event, $data);
    }

    private function getDistinctID(){
        $settings = SLN_Plugin::getInstance()->getSettings();
        if(!$settings->get('_sln_mixpanel_user_id')){
            $settings->set('_sln_mixpanel_user_id', (new DateTime())->getTimeStamp());
            $settings->save();
        }
        return $settings->get('_sln_mixpanel_user_id');
    }
}
